package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * @author akirakozov
 */
public class CmdUpdateTodoList extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "update-todo-list";

    @Autowired
    private TodoRoutines todoRoutines;

    public CmdUpdateTodoList(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        todoRoutines.updateTodoList(uidO.get(), dp, getActionInfo());
    }
}
