package ru.yandex.calendar.frontend.webNew;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.calendar.frontend.bender.FilterablePojo;
import ru.yandex.calendar.frontend.bender.FilterablePojoMarshallerUnmarshallerFactory;
import ru.yandex.calendar.frontend.bender.RawJson;
import ru.yandex.calendar.frontend.bender.RawJsonMarshaller;
import ru.yandex.calendar.frontend.bender.RawJsonUnmarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailMarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailUnmarshaller;
import ru.yandex.calendar.frontend.bender.WebDateTime;
import ru.yandex.calendar.frontend.bender.WebDateTimeMarshallerUnmarshaller;
import ru.yandex.calendar.frontend.webNew.dto.in.AvailabilitiesData;
import ru.yandex.calendar.frontend.webNew.dto.in.ImportIcsData;
import ru.yandex.calendar.frontend.webNew.dto.in.IntervalAndRepetitionData;
import ru.yandex.calendar.frontend.webNew.dto.in.LayerData;
import ru.yandex.calendar.frontend.webNew.dto.in.RepetitionWithStartData;
import ru.yandex.calendar.frontend.webNew.dto.in.ReplyData;
import ru.yandex.calendar.frontend.webNew.dto.in.SuggestData;
import ru.yandex.calendar.frontend.webNew.dto.in.UserSettingsData;
import ru.yandex.calendar.frontend.webNew.dto.in.UserTimezoneData;
import ru.yandex.calendar.frontend.webNew.dto.in.WebEventData;
import ru.yandex.calendar.frontend.webNew.dto.inOut.EventAttachmentData;
import ru.yandex.calendar.frontend.webNew.dto.inOut.RepetitionData;
import ru.yandex.calendar.frontend.webNew.dto.out.ContactsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.EventInfoShort;
import ru.yandex.calendar.frontend.webNew.dto.out.EventInfoWithSeries;
import ru.yandex.calendar.frontend.webNew.dto.out.EventsBrief;
import ru.yandex.calendar.frontend.webNew.dto.out.EventsCountInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.EventsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.Gap;
import ru.yandex.calendar.frontend.webNew.dto.out.GapsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.HolidaysInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.LayerIdInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.LayerInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.LayerOwnerInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.LayerPrivateToken;
import ru.yandex.calendar.frontend.webNew.dto.out.LayersInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.ModifiedEventIdsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.ModifyEventResult;
import ru.yandex.calendar.frontend.webNew.dto.out.MoveResourceEventsIds;
import ru.yandex.calendar.frontend.webNew.dto.out.NeedForRoomInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.NowTimeInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.OfficesInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.OfficesTzInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.ParseTimeInEventNameResult;
import ru.yandex.calendar.frontend.webNew.dto.out.RepetitionDescription;
import ru.yandex.calendar.frontend.webNew.dto.out.ReservationInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.ResourcesInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.ResourcesSchedule;
import ru.yandex.calendar.frontend.webNew.dto.out.StatusResult;
import ru.yandex.calendar.frontend.webNew.dto.out.SubjectsAvailabilities;
import ru.yandex.calendar.frontend.webNew.dto.out.SubjectsAvailabilityIntervals;
import ru.yandex.calendar.frontend.webNew.dto.out.SubscribeMobileInput;
import ru.yandex.calendar.frontend.webNew.dto.out.SuggestDatesInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.SuggestInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.TimezonesInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UserGapInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UserNeedForRoomInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UserOrResourceInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UserSettingsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UsersAndResourcesInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.WebEventInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.WebResourceInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.WebUserParticipantsInfo;
import ru.yandex.calendar.frontend.xiva.v2.models.XivaEntity;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryUtils;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.TimeFormats;

/**
 * @author gutman
 */
public class WebNewCodecs {

    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    private static final SetF<Class<?>> checkedParsers = Cf.hashSet();
    private static final SetF<Class<?>> checkedSerializers = Cf.hashSet();

    static {
        Cf.list(
                WebEventInfo.class, EventInfoShort.class, EventsInfo.class, EventsCountInfo.class,
                EventsBrief.class, ModifiedEventIdsInfo.class,
                SubjectsAvailabilityIntervals.class, ResourcesInfo.class, ReservationInfo.class, ResourcesSchedule.class,
                SubjectsAvailabilities.class, LayersInfo.class, LayerInfo.class, LayerIdInfo.class, LayerOwnerInfo.class,
                SuggestInfo.WithPlaces.class, SuggestInfo.WithNoPlaces.class, SuggestDatesInfo.class,
                OfficesInfo.class, OfficesTzInfo.class, MoveResourceEventsIds.class,
                UserSettingsInfo.class, RepetitionData.class, RepetitionDescription.class, StatusResult.class,
                UsersAndResourcesInfo.class, UserOrResourceInfo.User.class, UserOrResourceInfo.Resource.class,
                ModifyEventResult.Modified.class, ModifyEventResult.ResourceBusyOverlap.class,
                WebResourceInfo.class, ContactsInfo.class, ParseTimeInEventNameResult.class,
                FilterablePojo.class, NowTimeInfo.class, TimezonesInfo.class, HolidaysInfo.class,
                LayerPrivateToken.class, WebUserParticipantsInfo.class, EventInfoWithSeries.class,
                GapsInfo.class, UserGapInfo.class, Gap.class, NeedForRoomInfo.class, UserNeedForRoomInfo.class,
                SubscribeMobileInput.class, XivaEntity.class, EventAttachmentData.class
        ).forEach(preloadSerializerF());

        Cf.list(
                WebEventData.class, SuggestData.class, ReplyData.class, LayerData.class,
                ImportIcsData.class, ImportIcsData.Layer.class,
                UserSettingsData.class, UserTimezoneData.class, IntervalAndRepetitionData.class,
                RepetitionData.class, RepetitionWithStartData.class, AvailabilitiesData.class,
                EventAttachmentData.class
        ).forEach(preloadParserAndSerializerF()); // for request data logging
    }

    public static BenderConfiguration getConfiguration() {
        final Function0<BenderMapper> mapperF = () -> mapper;
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryUtils.combine(
                        new FilterablePojoMarshallerUnmarshallerFactory(mapperF),
                        CustomMarshallerUnmarshallerFactoryBuilder.cons()
                                .add(Duration.class, new DurationMarshaller(), new DurationUnmarshaller())
                                .add(Email.class, new UnicodeEmailMarshaller(), new UnicodeEmailUnmarshaller())
                                .add(LocalDate.class, new LocalDateMarshaller(), new LocalDateUnmarshaller())
                                .add(LocalTime.class, new LocalTimeMarshaller(), new LocalTimeUnmarshaller())
                                .add(Instant.class, new InstantAsMillisMarshaller(), new InstantAsMillisUnmarshaller())
                                .add(WebDateTime.class,
                                        new WebDateTimeMarshallerUnmarshaller(),
                                        new WebDateTimeMarshallerUnmarshaller())
                                .add(RawJson.class, new RawJsonMarshaller(), new RawJsonUnmarshaller())
                                .build()));
    }

    private static Function1V<Class<?>> preloadSerializerF() {
        return c -> {
            mapper.createSerializer(c);
            checkedSerializers.add(c);
        };
    }

    private static Function1V<Class<?>> preloadParserAndSerializerF() {
        return c -> {
            mapper.preloadSerializerAndParser(c);
            checkedParsers.add(c);
            checkedSerializers.add(c);
        };
    }

    public static <T> BenderParser<T> getParser(Class<T> clazz) {
        Validate.in(clazz, checkedParsers);
        return mapper.createParser(clazz);
    }

    public static <T> BenderSerializer<T> getSerializer(Class<T> clazz) {
        Validate.in(clazz, checkedSerializers);
        return mapper.createSerializer(clazz);
    }

    public static boolean hasSerializerFor(Class<?> clazz) {
        return checkedSerializers.containsTs(clazz);
    }

    private static class DurationUnmarshaller extends SimpleTypeUnmarshallerSupport {
        protected Object convert(String o) {
            String durationStr = o;
            boolean minus = false;

            if (durationStr.startsWith("-")) {
                durationStr = durationStr.substring(1);
                minus = true;
            }
            Validate.isTrue(durationStr.endsWith("m"));
            durationStr = durationStr.substring(0, durationStr.length() - 1);
            int minutes = Integer.parseInt(durationStr);
            minutes = minus ? -minutes : minutes;
            return Duration.standardMinutes(minutes);
        }
    }

    private static class DurationMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            Validate.isTrue(o instanceof Duration);
            return ((Duration) o).getStandardMinutes() + "m";
        }
    }

    private static class LocalDateMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            Validate.isTrue(o instanceof LocalDate);
            return TimeFormats.ISO_DATE_FORMATTER.print((LocalDate) o);
        }
    }

    private static class LocalDateUnmarshaller extends SimpleTypeUnmarshallerSupport {
        protected Object convert(String o) {
            return TimeFormats.ISO_DATE_FORMATTER.parseLocalDate(o);
        }
    }

    private static class LocalTimeMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            Validate.isTrue(o instanceof LocalTime);
            return ((LocalTime) o).toString("HH:mm") ;
        }
    }

    private static class LocalTimeUnmarshaller extends SimpleTypeUnmarshallerSupport {
        protected Object convert(String o) {
            return LocalTime.parse(o);
        }
    }

}
