package ru.yandex.calendar.frontend.webNew;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.frontend.a3.error.ReadableMessageExceptionHandler;
import ru.yandex.calendar.frontend.a3.interceptors.CalendarRequestInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.CommandExecutionMonitoringInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.LogActionParametersInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.SetAdditionalAttrsInterceptor;
import ru.yandex.calendar.frontend.a3.redirect.RedirectContextA3Configuration;
import ru.yandex.calendar.frontend.api.todo.ApiTodoContextConfiguration;
import ru.yandex.calendar.frontend.webNew.actions.WebNewActionsContextConfiguration;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextA3Configuration;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.A3DefaultContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.a3.db.MasterSlavePolicyInterceptor;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        A3DefaultContextConfiguration.class,
        WebNewContextConvertersConfiguration.class,
        WebNewActionsContextConfiguration.class,
        ApiTodoContextConfiguration.class,
        RequestLoggingContextA3Configuration.class,
        RedirectContextA3Configuration.class,
})
public class WebNewContextA3Configuration {

    @Autowired
    @Qualifier("webNewJetty")
    private SingleWarJetty jetty;
    @Autowired
    private ActionApp actionApp;

    @PostConstruct
    public void configure() {
        jetty.addServletMapping("/*", actionApp.createServlet());
    }

    @Bean
    public ApplicationInfo applicationInfo(CalendarAppName calendarAppName, Version version) {
        return new ApplicationInfo(calendarAppName.appName(), version.getProjectVersion());
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_XML);
    }

    @Bean
    public WebNewResultSerializer webNewResultSerializer() {
        return new WebNewResultSerializer();
    }

    @Bean
    public WebNewJsonResultSerializer webNewJsonResultSerializer() {
        return new WebNewJsonResultSerializer();
    }

    @Bean
    public CalendarRequestInterceptor calendarRequestInterceptor(PassportAuthDomainsHolder domains, TvmManager tvmManager) {
        // By default we expect new front web here
        return new CalendarRequestInterceptor(ActionSource.WEB_MAYA, domains, tvmManager);
    }

    @Bean
    public MasterSlavePolicyInterceptor masterSlavePolicyInterceptor() {
        return new MasterSlavePolicyInterceptor();
    }

    @Bean
    public LogActionParametersInterceptor logActionParametersInterceptor() {
        return new LogActionParametersInterceptor();
    }

    @Bean
    public SetAdditionalAttrsInterceptor setAdditionalAttrsInterceptor() {
        return new SetAdditionalAttrsInterceptor();
    }

    @Bean
    public ReadableMessageExceptionHandler readableMessageExceptionHandler() {
        return new ReadableMessageExceptionHandler();
    }

    @Bean
    public CommandExecutionMonitoringInterceptor commandExecutionMonitoringInterceptor() {
        return new CommandExecutionMonitoringInterceptor();
    }
}
