package ru.yandex.calendar.frontend.webNew;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.admin.CalendarPingServlet;
import ru.yandex.calendar.logic.log.requests.RequestContentCachingFilter;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextConfiguration;
import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.calendar.util.spring.ChildApplicationContextLoader;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author gutman
 */
@Configuration
@Import({
        WebApiMonitoringConfiguration.class,
        WebNewContextManagersConfiguration.class,
        RequestLoggingContextConfiguration.class,
})
public class WebNewContextConfiguration {
    @Bean
    @Qualifier("webNewJetty")
    public SingleWarJetty webNewJetty(RequestContentCachingFilter cachingFilter) {
        SingleWarJetty jetty = JettyConfiguration.fromProperties("webNew").consJetty();

        jetty.addServletMapping("/ping/*", webNewPingConfigurableServlet());
        jetty.addFilterMapping("/*", cachingFilter);
        return jetty;
    }

    @Bean
    public CalendarPingServlet webNewPingConfigurableServlet() {
        return new CalendarPingServlet();
    }

    @Bean
    public ChildApplicationContextLoader webNewA3ContextLoader() {
        return new ChildApplicationContextLoader(WebNewContextA3Configuration.class);
    }
}
