package ru.yandex.calendar.frontend.webNew;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.frontend.a3.bind.JsonBinder;
import ru.yandex.calendar.frontend.a3.converters.CalendarConverterToLocalDateTime;
import ru.yandex.calendar.frontend.a3.converters.ConverterToDateTimeZone;
import ru.yandex.calendar.frontend.a3.converters.ConverterToEmail;
import ru.yandex.calendar.frontend.a3.converters.ConverterToFilteringFields;
import ru.yandex.calendar.frontend.a3.converters.ConverterToLanguage;
import ru.yandex.calendar.frontend.a3.converters.ConverterToWebDate;
import ru.yandex.calendar.frontend.webNew.bind.ImportIcsDataBinder;

/**
 * @author dbrylev
 */
@Configuration
public class WebNewContextConvertersConfiguration {

    @Bean
    public JsonBinder jsonBinder() {
        return new JsonBinder(WebNewCodecs.mapper);
    }

    @Bean
    public ImportIcsDataBinder importIcsDataBinder() {
        return new ImportIcsDataBinder(jsonBinder());
    }

    @Bean
    public ConverterToEmail converterToEmail() {
        return new ConverterToEmail();
    }

    @Bean
    public CalendarConverterToLocalDateTime converterToLocalDateTime() {
        return new CalendarConverterToLocalDateTime();
    }

    @Bean
    public ConverterToDateTimeZone converterToDateTimeZone() {
        return new ConverterToDateTimeZone();
    }

    @Bean
    public ConverterToLanguage converterToLanguage() {
        return new ConverterToLanguage();
    }

    @Bean
    public ConverterToFilteringFields converterToFilteringFields() {
        return new ConverterToFilteringFields();
    }

    @Bean
    public ConverterToWebDate converterToWebDate() {
        return new ConverterToWebDate();
    }
}
