package ru.yandex.calendar.frontend.webNew;

import java.io.OutputStream;

import ru.yandex.calendar.frontend.bender.WebDateUtils;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.io.OutputStreamOutputStreamSource;

/**
 * @author dbrylev
 */
public class WebNewJsonResultSerializer extends AbstractResultSerializer {

    @Override
    @SuppressWarnings("unchecked")
    protected void serializeSafely(Object result, ActionInvocationContext context, OutputStream stream) {
        BenderSerializer serializer = WebNewCodecs.getSerializer(result.getClass());
        serializer.serializeJson(result,
                new OutputStreamOutputStreamSource(stream),
                WebDateUtils.marshallerContext(context.getRequest()));
    }

    @Override
    protected boolean supports(Object result) {
        return WebNewCodecs.hasSerializerFor(result.getClass());
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
