package ru.yandex.calendar.frontend.webNew;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

import ru.yandex.calendar.frontend.bender.WebDateUtils;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.io.OutputStreamOutputStreamSource;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.xml.stream.XmlWriter;
import ru.yandex.misc.xml.stream.XmlWriterFactory;

/**
 * @author gutman
 */
public class WebNewResultSerializer extends AbstractResultSerializer {

    @Override
    @SuppressWarnings("unchecked")
    protected void serializeSafely(Object result, ActionInvocationContext context, OutputStream outputStream) {
        BenderSerializer serializer = WebNewCodecs.getSerializer(result.getClass());
        // XXX: serialize directly to json
        try (XmlWriter writer = XmlWriterFactory.defaultFactory().createXmlWriter(outputStream)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.serializeJson(
                    result, new OutputStreamOutputStreamSource(baos),
                    WebDateUtils.marshallerContext(context.getRequest()));

            writer.textElement("result", CharsetUtils.decodeUtf8(baos.toByteArray()));
            writer.flush();
        }
    }

    @Override
    public boolean supports(Object result) {
        return WebNewCodecs.hasSerializerFor(result.getClass());
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_XML;
    }
}
