package ru.yandex.calendar.frontend.webNew.actions;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.bind.BindJson;
import ru.yandex.calendar.frontend.webNew.dto.out.SubscribeMobileInput;
import ru.yandex.calendar.frontend.xiva.v2.XivaHttpClient;
import ru.yandex.calendar.frontend.xiva.v2.models.XivaEntity;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

@ActionContainer
public class NotificationActions {
    @Autowired
    private XivaHttpClient xivaHttpClient = new XivaHttpClient();

    @Action
    public void createSubscription(@RequestParam("uid") Long uid, @BindJson SubscribeMobileInput input) {
        xivaHttpClient.subscribeApp(
                input.getOauthToken(),
                uid,
                input.getAppName(),
                input.getPlatform(),
                input.getUuid(),
                input.getPushToken(),
                input.getFilter(),
                input.getExtra());
    }

    @Action
    public void sendTestNotification(
            @RequestParam("uid") Long uid,
            @RequestParam("eventType") String eventType,
            @RequestParam("ttl") int ttl,
            @BindJson XivaEntity entity) {
        xivaHttpClient.postNotification(uid, eventType, entity, ttl);
    }
}
