package ru.yandex.calendar.frontend.webNew.actions;

import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.bind.BindJson;
import ru.yandex.calendar.frontend.webNew.WebNewUserManager;
import ru.yandex.calendar.frontend.webNew.dto.in.UserSettingsData;
import ru.yandex.calendar.frontend.webNew.dto.in.UserTimezoneData;
import ru.yandex.calendar.frontend.webNew.dto.out.ContactsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.NowTimeInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.StatusResult;
import ru.yandex.calendar.frontend.webNew.dto.out.TimezonesInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UserSettingsInfo;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
public class UserActions {

    @Autowired
    private WebNewUserManager webNewUserManager;

    @WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
    @Action
    public UserSettingsInfo getUserSettings(@RequestParam("uid") PassportUid uid) {
        return webNewUserManager.getUserSettings(uid);
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
    @Action
    public NowTimeInfo getNowTime(
            @RequestParam("uid") Option<PassportUid> uid,
            @RequestParam("tz") Option<DateTimeZone> tz)
    {
        return webNewUserManager.getNowTime(uid, tz);
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public StatusResult updateUserSettings(@RequestParam("uid") PassportUid uid, @BindJson UserSettingsData data) {
        webNewUserManager.updateUserSettings(uid, data);
        return StatusResult.ok();
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public StatusResult updateUserTimezone(@RequestParam("uid") PassportUid uid, @BindJson UserTimezoneData data) {
        webNewUserManager.updateUserTimezone(uid, data);
        return StatusResult.ok();
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
    @Action
    public ContactsInfo findFavoriteContacts(
            @RequestParam("uid") PassportUid uid,
            @RequestParam("limit") Option<Integer> limit,
            @RequestParam("lang") Option<Language> lang)
    {
        return webNewUserManager.findFavoriteContacts(uid, limit.getOrElse(50), lang.getOrElse(Language.RUSSIAN));
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.CUT_OFF)
    @Action
    public TimezonesInfo getTimezones() {
        return new TimezonesInfo(Cf.x(DateTimeZone.getAvailableIDs()).filterMap(
                id -> Option.when(!id.startsWith("tz20"), () -> TimezonesInfo.TimezoneInfo.forID(id))));
    }
}
