package ru.yandex.calendar.frontend.webNew.actions;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.webNew.WebNewGapsManager;
import ru.yandex.calendar.frontend.webNew.dto.out.GapsInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.NeedForRoomInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.UserGapInfo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
public class UserGapsActions {
    @Autowired
    private WebNewGapsManager gapsManager;

    @WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
    @Action
    public GapsInfo getUserGaps(
            @RequestParam("from") LocalDateTime from,
            @RequestParam("to") LocalDateTime to,
            @RequestParam("users") ListF<String> userLogins,
            @RequestParam("tz") DateTimeZone tz
    ) {
        MapF<String, UserGapInfo> result = gapsManager.getUserGapsByUserLogins(from, to, userLogins, tz);
        return new GapsInfo(result);
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
    @Action
    public NeedForRoomInfo isRoomNeeded(
            @RequestParam("from") LocalDateTime from,
            @RequestParam("to") LocalDateTime to,
            @RequestParam("users") ListF<String> userLogins,
            @RequestParam("tz") DateTimeZone tz,
            @RequestParam("isMixedAsRemote") Option<Boolean> isMixedAsRemote
    ) {
        return gapsManager.isRoomNeeded(from, to, userLogins, tz, isMixedAsRemote.orElse(true));
    }
}
