package ru.yandex.calendar.frontend.webNew.bind;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.bind.JsonBinder;
import ru.yandex.calendar.frontend.a3.interceptors.LoggingParameterBinder;
import ru.yandex.calendar.frontend.webNew.dto.in.ImportIcsData;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.Parameter;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.web.servlet.MultipartHttpServletRequestX;
import ru.yandex.misc.web.servlet.multipart.CommonsMultipartResolver;
import ru.yandex.misc.web.servlet.multipart.MultipartFile;
import ru.yandex.misc.web.servlet.multipart.MultipartResolver;

/**
 * @author dbrylev
 */
public class ImportIcsDataBinder implements ParameterBinder, LoggingParameterBinder {

    private final JsonBinder jsonBinder;
    private final MultipartResolver multipartResolver;

    public ImportIcsDataBinder(JsonBinder jsonBinder) {
        this.jsonBinder = jsonBinder;
        this.multipartResolver = new CommonsMultipartResolver();
    }

    @Nullable
    @Override
    public Object createAndBind(
            WebRequest webRequest, ActionInvocationContext invocationContext, ParameterDescriptor parameterDescriptor)
    {
        Validate.isTrue(multipartResolver.isMultipart(webRequest.getHttpServletRequest()), "Multipart expected");
        HttpServletRequestUtils.defaultToUtf8Encoding(webRequest.getHttpServletRequest());

        MultipartHttpServletRequestX multipart = multipartResolver.resolveMultipart(webRequest.getHttpServletRequest());

        Option<byte[]> ics = multipart.getFileO("ics").map(MultipartFile::getBytes);
        Option<String> url = multipart.getParameterO("url");

        ImportIcsData.Layer layer = jsonBinder.getMapper().parseJson(
                ImportIcsData.Layer.class, multipart.getParameter("layer"));

        return new ImportIcsData(ics, url, layer);
    }

    @Override
    public Option<String> getNameForLogging(Parameter parameter) {
        return jsonBinder.getNameForLogging(parameter);
    }

    @Override
    public Option<String> getValueForLogging(Parameter parameter) {
        return jsonBinder.getValueForLogging(parameter);
    }
}
