package ru.yandex.calendar.frontend.webNew.dto.in;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.avail.AvailabilityRequest;

/**
 * @author dbrylev
 */
public enum AvailDisplayMode {
    EVENTS_AND_ABSENCES,
    EVENTS_ONLY,
    ABSENCES_ONLY,
    ;

    public static AvailDisplayMode of(Option<String> value) {
        return value.isSome("events") ? EVENTS_ONLY
                : value.isSome("absences") ? ABSENCES_ONLY
                : EVENTS_AND_ABSENCES;
    }

    public AvailabilityRequest applyTo(AvailabilityRequest request) {
        switch (this) {
            case EVENTS_ONLY: return request.excludeAbsencesEvents();
            case ABSENCES_ONLY: return request.excludeNonAbsencesEvents();
        }
        return request;
    }
}
