package ru.yandex.calendar.frontend.webNew.dto.in;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.avail.AvailabilityRequest;

/**
 * @author dbrylev
 */
public enum AvailShapeType {
    IDS_ONLY,
    OMIT_PARTICIPANTS,
    FULL_INFO,
    FULL_INFO_WITH_ACTIONS,
    ;

    public static AvailShapeType of(Option<String> shape, Option<Boolean> idsOnly) {
        if (shape.isSome("full_actions")) {
            return FULL_INFO_WITH_ACTIONS;
        } else if (shape.isSome("ids-only") || idsOnly.isSome(true)) {
            return IDS_ONLY;
        } else if (shape.isSome("omit-participants")) {
            return OMIT_PARTICIPANTS;
        }
        return FULL_INFO;
    }

    public boolean isWithResources() {
        return this != IDS_ONLY;
    }

    public boolean isWithAttendees() {
        return this != OMIT_PARTICIPANTS && this != IDS_ONLY;
    }

    public AvailabilityRequest applyTo(AvailabilityRequest request) {
        switch (this) {
            case FULL_INFO: return request.includeEventsInfo();
            case FULL_INFO_WITH_ACTIONS: return request.includeEventsInfo().includeActions();
            case OMIT_PARTICIPANTS: return request.includeEventsNames().includeEventsResources();
        }
        return request;
    }
}
