package ru.yandex.calendar.frontend.webNew.dto.in;

import lombok.AllArgsConstructor;
import lombok.Setter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.webNew.dto.inOut.RepetitionData;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@AllArgsConstructor
@Setter
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class AvailabilitiesData {

    private ListF<Email> emails;
    @BenderFlatten
    private IntervalAndRepetitionData interval;

    public RepetitionInstanceInfo toRepetitionInstanceInfo(DateTimeZone dataTz, DateTimeZone repetitionTz) {
        return interval.toRepetitionInstanceInfo(dataTz, repetitionTz);
    }

    public ListF<Email> getEmails() {
        return emails;
    }

    public LocalDateTime getStart() {
        return interval.getStart();
    }

    public LocalDateTime getEnd() {
        return interval.getEnd();
    }

    public Option<RepetitionData> getRepetition() {
        return interval.getRepetition();
    }
}
