package ru.yandex.calendar.frontend.webNew.dto.in;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.IcsUtils;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;

@BenderBindAllFields
public class ImportIcsData {
    private final Option<IcsWrapper> ics;
    @Getter
    private final Option<String> url;
    private final Layer layer;

    public ImportIcsData(Option<byte[]> ics, Option<String> url, Layer layer) {
        this.ics = ics.map(IcsWrapper::new);
        this.url = url;
        this.layer = layer;
    }

    public static Optional<IcsCalendar> getIcs(Optional<IcsWrapper> ics) {
        return ics.map(i -> IcsUtils.parseBytesInGuessedEncoding(i.bytes));
    }

    public Option<IcsWrapper> getIcsWrapper() {
        return ics;
    }

    public boolean isFeed() {
        return layer.reference.equals("feed");
    }

    public boolean isNew() {
        return layer.reference.equals("new");
    }

    public Option<Long> getLayerId() {
        return Cf.Long.parseSafe(layer.reference);
    }

    public LayerData getLayerData() {
        return layer.data;
    }

    @Value
    @BenderBindAllFields
    public static class IcsWrapper {
        byte[] bytes;
    }

    @AllArgsConstructor
    @BenderBindAllFields
    public static class Layer {
        private String reference;
        @BenderFlatten
        private LayerData data;
    }
}
