package ru.yandex.calendar.frontend.webNew.dto.in;

import lombok.AllArgsConstructor;
import lombok.Setter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.webNew.dto.inOut.RepetitionData;
import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.commune.a3.action.parameter.ValidateParam;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
@AllArgsConstructor
@Setter
@BenderBindAllFields
public class IntervalAndRepetitionData {
    private LocalDateTime start;
    private LocalDateTime end;
    private Option<RepetitionData> repetition;

    public RepetitionInstanceInfo toRepetitionInstanceInfo(DateTimeZone dataTz, DateTimeZone repetitionTz) {
        ValidateParam.isFalse("start/end", start.isAfter(end), "Start should not be after end");

        InstantInterval interval = new InstantInterval(
                AuxDateTime.toInstantIgnoreGap(start, dataTz),
                AuxDateTime.toInstantIgnoreGap(end, dataTz));

        Option<Repetition> repetitionO = repetition.isPresent()
                ? Option.of(repetition.get().toRepetition(interval.getStart(), repetitionTz))
                : Option.<Repetition>empty();

        return RepetitionInstanceInfo.create(interval, repetitionTz, repetitionO);
    }

    public LocalDateTime getStart() {
        return start;
    }

    public LocalDateTime getEnd() {
        return end;
    }

    public Option<RepetitionData> getRepetition() {
        return repetition;
    }
}
