package ru.yandex.calendar.frontend.webNew.dto.in;

import lombok.Getter;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;

import ru.yandex.calendar.frontend.webNew.dto.inOut.RepetitionData;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
@Getter
public class RepetitionWithStartData {
    private RepetitionData repetition;
    private LocalDateTime startTs;

    public Instant getStartTs(DateTimeZone tz) {
        return AuxDateTime.toInstantIgnoreGap(startTs, tz);
    }
}
