package ru.yandex.calendar.frontend.webNew.dto.in;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.model.WebReplyData;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author gutman
 */
@AllArgsConstructor
@Getter
@Bendable
public class ReplyData {

    @BenderPart
    private long eventId;
    @BenderPart
    private Decision decision;
    @BenderPart
    private Option<String> privateToken;
    @BenderPart
    private Option<LocalDateTime> instanceStartTs;
    @BenderPart
    private Option<Boolean> applyToAll;
    @BenderPart
    private Option<String> tz;
    @BenderPart
    private Option<String> reason;
    @BenderPart
    private Option<Availability> availability;
    @BenderPart(name = "notification", wrapperName = "notifications")
    private Option<ListF<Notification>> notifications;

    public ReplyData(long eventId, Decision decision) {
        this(eventId, decision,
                Option.empty(), Option.empty(), Option.empty(),
                Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    public long getEventId() {
        return eventId;
    }

    public Option<String> getPrivateToken() {
        return privateToken;
    }

    public Option<LocalDateTime> getInstanceStartTs() {
        return instanceStartTs;
    }

    public Option<Boolean> getApplyToAll() {
        return applyToAll;
    }

    public Option<DateTimeZone> getTz() {
        return tz.isPresent() ? Option.of(DateTimeZone.forID(tz.get())) : Option.<DateTimeZone>empty();
    }

    public Decision getDecision() {
        return decision;
    }

    public Option<String> getReason() {
        return reason;
    }

    public EventUser getEventUser() {
        EventUser eventUser = new EventUser();
        if (availability.isPresent()) {
            eventUser.setAvailability(availability.get());
        }
        return eventUser;
    }

    public NotificationsData.Create getNotificationsData() {
        if (notifications.isPresent()) {
            return NotificationsData.createFromWeb(notifications.get());
        } else {
            return NotificationsData.useLayerDefaultIfCreate();
        }
    }

    public WebReplyData toWebReplyData() {
        return new WebReplyData(decision, reason, Option.<Long>empty(), availability, getNotificationsData());
    }
}
