package ru.yandex.calendar.frontend.webNew.dto.in;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.model.Completion;
import ru.yandex.calendar.logic.event.model.EventUserData;
import ru.yandex.calendar.logic.event.model.Priority;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@AllArgsConstructor
@Getter
@Setter
@Builder(toBuilder = true)
@BenderBindAllFields
public class WebEventUserData {
    private Option<Availability> availability;
    private Option<Long> layerId;
    @BenderPart(name = "notification", wrapperName = "notifications")
    private Option<ListF<Notification>> notifications;

    public static WebEventUserData empty() {
        return new WebEventUserData(Option.empty(), Option.empty(), Option.empty());
    }

    public EventUserData getEventUserData() {
        EventUser eventUser = new EventUser();
        if (availability.isPresent()) {
            eventUser.setAvailability(availability.get());
        }
        eventUser.setCompletion(Completion.NOT_APPLICABLE);
        eventUser.setPriority(Priority.NORMAL);
        return new EventUserData(eventUser, getNotifications().getOrElse(Cf.list()));
    }

    public NotificationsData.Create getNotificationsCreateData() {
        return notifications.map(NotificationsData::createFromWeb).getOrElse(NotificationsData::useLayerDefaultIfCreate);
    }
}
