package ru.yandex.calendar.frontend.webNew.dto.inOut;

import lombok.EqualsAndHashCode;
import lombok.Setter;

import ru.yandex.calendar.logic.beans.generated.EventAttachment;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

@Setter
@EqualsAndHashCode
@BenderBindAllFields
public class EventAttachmentData extends DefaultObject {
    private String fileName;
    private String url;
    private long size;

    public EventAttachmentData(String attachmentUrl, String attachmentFileName, long attachmentSize) {
        url = attachmentUrl;
        fileName = attachmentFileName;
        size = attachmentSize;
    }

    public static EventAttachmentData fromEventAttachment(EventAttachment attachment) {
        return new EventAttachmentData(attachment.getUrl(), attachment.getFilename(), attachment.getSize());
    }

    public EventAttachment toEventAttachment() {
        EventAttachment attachment = new EventAttachment();
        attachment.setFilename(fileName);
        attachment.setUrl(url);
        attachment.setSize(size);

        return attachment;
    }
}
