package ru.yandex.calendar.frontend.webNew.dto.inOut;

import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class NoNotificationsRange {
    private Option<LocalDate> sinceDate;
    private Option<LocalDate> untilDate;
    private Option<LocalTime> fromTime;
    private Option<LocalTime> toTime;

    public NoNotificationsRange(
            Option<LocalDate> sinceDate, Option<LocalDate> untilDate,
            Option<LocalTime> fromTime, Option<LocalTime> toTime)
    {
        this.sinceDate = sinceDate;
        this.untilDate = untilDate;
        this.fromTime = fromTime;
        this.toTime = toTime;
    }

    public Option<LocalDate> getSinceDate() {
        return sinceDate;
    }

    public Option<LocalDate> getUntilDate() {
        return untilDate;
    }

    public Option<LocalTime> getFromTime() {
        return fromTime;
    }

    public Option<LocalTime> getToTime() {
        return toTime;
    }
}
