package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Data;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
public class AvailabilityInfo {
    private final Option<String> availability;
    private final Option<LocalDate> dueDate;
    private final Option<Integer> availableRepetitions;

    public static AvailabilityInfo empty() {
        return new AvailabilityInfo(Option.empty(), Option.empty(), Option.empty());
    }

    public AvailabilityInfo withoutValue() {
        return new AvailabilityInfo(Option.empty(), dueDate, availableRepetitions);
    }
}
