package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@Getter
@Bendable
public class ContactsInfo {

    @BenderPart(name = "contact", wrapperName = "contacts")
    private final ListF<ContactInfo> resources;

    public ContactsInfo(ListF<ContactInfo> resources) {
        this.resources = resources;
    }

    public ListF<Email> getEmails() {
        return resources.map(ContactInfo::getEmail);
    }

    @Getter
    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class ContactInfo {
        private final String name;
        private final Email email;
        private final Option<String> login;

        public ContactInfo(String name, Email email, Option<String> login) {
            this.name = name;
            this.email = email;
            this.login = login;
        }
    }
}
