package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.event.model.EventType;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
public class DeletedEventInfo {
    private final long layerId;
    private final EventType type;
    private final String externalId;
    private final Instant deletionTs;

    public DeletedEventInfo(long layerId, EventType type, String externalId, Instant deletionTs) {
        this.layerId = layerId;
        this.type = type;
        this.externalId = externalId;
        this.deletionTs = deletionTs;
    }
}
