package ru.yandex.calendar.frontend.webNew.dto.out;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class EventInfoShort {
    private long id;
    private String name;
    private String description;
    private LocalDateTime startTs;
    private LocalDateTime endTs;
    private boolean isAllDay;

    public EventInfoShort(Event event, DateTimeZone tz) {
        this.id = event.getId();
        this.name = event.getName();
        this.description = event.getDescription();
        this.startTs = event.getStartTs().toDateTime(tz).toLocalDateTime();
        this.endTs = event.getEndTs().toDateTime(tz).toLocalDateTime();
        this.isAllDay = event.getIsAllDay();
    }

}
