package ru.yandex.calendar.frontend.webNew.dto.out;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Rdate;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Value
@BenderBindAllFields
@AllArgsConstructor
public class ExdateBrief {
    Instant startTs;
    Optional<Instant> endTs;

    public ExdateBrief(Rdate exdate) {
        this(exdate.getStartTs(), exdate.getEndTs().toOptional());
    }
}
