package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.holidays.DayType;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class HolidaysInfo {
    public final ListF<Holiday> holidays;

    public HolidaysInfo(ListF<Holiday> holidays) {
        this.holidays = holidays;
    }

    public Option<Holiday> find(LocalDate date) {
        return holidays.find(h -> h.date.equals(date));
    }

    @Getter
    @BenderBindAllFields
    public static class Holiday {
        private final LocalDate date;
        private final DayType type;
        private final Option<LocalDate> transferDate;
        private final Option<String> name;

        public Holiday(LocalDate date, DayType type, Option<LocalDate> transferDate, Option<String> name) {
            this.date = date;
            this.type = type;
            this.transferDate = transferDate;
            this.name = name;
        }
    }
}
