package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.layer.LayerType;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.sharing.perm.LayerActionClass;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;

@Getter
@BenderBindAllFields
public class LayerInfo {
    private final long id;
    private final String name;
    private final String color;
    private final Integer defaultEventsDurationMinutes;

    private final boolean canAddEvent;
    private final boolean isDefault;
    private final LayerActionClass perm;

    private final ListF<Notification> notifications;
    private final boolean notifyAboutEventChanges;
    private final boolean affectAvailability;

    private final boolean isOwner;
    private final boolean isParticipant;

    private final Option<WebUserInfo> owner;

    private final String type;

    // owner related
    private final Option<String> token;
    private final Option<FeedInfo> icsFeed;
    private final Option<Boolean> isEventsClosedByDefault;
    private final Option<ListF<Participant>> participants;

    public LayerInfo(
            long id, String name, String color, Integer defaultEventsDurationMinutes,
            boolean canAddEvent, boolean isDefault,
            LayerActionClass perm,
            ListF<Notification> notifications, boolean notifyAboutEventChanges,
            boolean affectAvailability,
            boolean isOwner, LayerType type, boolean isParticipant,
            Option<WebUserInfo> owner, Option<String> token,
            Option<FeedInfo> icsFeed,
            Option<Boolean> isEventsClosedByDefault,
            Option<ListF<Participant>> participants)
    {
        this.id = id;
        this.name = name;
        this.color = color;
        this.defaultEventsDurationMinutes = defaultEventsDurationMinutes;
        this.canAddEvent = canAddEvent;
        this.isDefault = isDefault;
        this.perm = perm;
        this.notifications = notifications;
        this.notifyAboutEventChanges = notifyAboutEventChanges;
        this.affectAvailability = affectAvailability;
        this.isOwner = isOwner;
        this.type = type.value();
        this.isParticipant = isParticipant;
        this.owner = owner;
        this.token = token;
        this.icsFeed = icsFeed;
        this.isEventsClosedByDefault = isEventsClosedByDefault;
        this.participants = participants;
    }

    @Getter
    @BenderBindAllFields
    public static class FeedInfo {
        private final Option<LocalDateTime> lastUpdate;
        private final String url;

        public FeedInfo(Option<LocalDateTime> lastUpdate, String url) {
            this.lastUpdate = lastUpdate;
            this.url = url;
        }
    }

    @Getter
    @BenderBindAllFields
    public static class Participant {
        @BenderFlatten
        private final WebUserInfo info;
        private final LayerActionClass permission;

        public Participant(WebUserInfo info, LayerActionClass permission) {
            this.info = info;
            this.permission = permission;
        }
    }
}
