package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.layer.LayerType;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.util.color.Color;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

@Getter
@Bendable
public class LayersInfo {
    @BenderPart(name = "layer", wrapperName = "layers")
    private final ListF<LayerInfo> layers;

    public LayersInfo(ListF<LayerInfo> layers) {
        this.layers = layers;
    }

    @Getter
    @Bendable
    public static class LayerInfo {
        @BenderPart
        private final long id;
        @BenderPart
        private final String name;
        @BenderPart
        private final boolean isToggledOn;
        @BenderPart
        private final boolean canAddEvent;
        @BenderPart
        private final boolean isEventsClosedByDefault;
        @BenderPart
        private final boolean isOwner;
        @BenderPart
        private final Option<WebUserInfo> owner;
        @BenderPart
        private final String color;
        @BenderPart
        private final Integer defaultEventsDurationMinutes;
        @BenderPart
        private final ListF<Notification> notifications;
        @BenderPart
        private final boolean affectsAvailability;
        @BenderPart
        private final boolean isDefault;
        @BenderPart
        private final String type;
        @BenderPart
        private final Option<Integer> participantsCount;

        public LayerInfo(long id, String name,
                boolean isToggledOn, boolean canAddEvent, boolean isEventsClosedByDefault,
                boolean isOwner, Option<WebUserInfo> owner, Color color, Integer defaultEventsDurationMinutes, ListF<Notification> notifications,
                boolean affectsAvailability, boolean isDefault, LayerType type, Option<Integer> participantsCount)
        {
            this.id = id;
            this.name = name;
            this.isToggledOn = isToggledOn;
            this.canAddEvent = canAddEvent;
            this.isEventsClosedByDefault = isEventsClosedByDefault;
            this.isOwner = isOwner;
            this.owner = owner;
            this.color = color.printRgb();
            this.defaultEventsDurationMinutes = defaultEventsDurationMinutes;
            this.notifications = notifications;
            this.affectsAvailability = affectsAvailability;
            this.isDefault = isDefault;
            this.type = type.value();
            this.participantsCount = participantsCount;
        }
    }

    public ListF<Long> getOwnUserLayers() {
        return layers.filter(li -> li.isOwner && li.type.equals(LayerType.USER.value())).map(li -> li.id);
    }

}
