package ru.yandex.calendar.frontend.webNew.dto.out;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.time.InstantInterval;

/**
* @author gutman
*/
@Bendable
public class LocalDateTimeInterval extends DefaultObject {

    @BenderPart
    private final LocalDateTime start;
    @BenderPart
    private final LocalDateTime end;

    public LocalDateTimeInterval(LocalDateTime start, LocalDateTime end) {
        this.start = start;
        this.end = end;
    }

    public LocalDateTimeInterval(ReadableInstant start, ReadableInstant end, DateTimeZone tz) {
        this(new LocalDateTime(start, tz), new LocalDateTime(end, tz));
    }

    public LocalDateTimeInterval(InstantInterval instantInterval, DateTimeZone tz) {
        this(instantInterval.getStart(), instantInterval.getEnd(), tz);
    }

    public static Function<InstantInterval, LocalDateTimeInterval> fromInstantIntervalF(final DateTimeZone tz) {
        return new Function<InstantInterval, LocalDateTimeInterval>() {
            public LocalDateTimeInterval apply(InstantInterval instantInterval) {
                return new LocalDateTimeInterval(instantInterval, tz);
            }
        };
    }

    public LocalDateTime getStart() {
        return start;
    }

    public LocalDateTime getEnd() {
        return end;
    }

    public static Function<LocalDateTimeInterval, LocalDateTime> getStartF() {
        return new Function<LocalDateTimeInterval, LocalDateTime>() {
            public LocalDateTime apply(LocalDateTimeInterval i) {
                return i.getStart();
            }
        };
    }

    public static Function<LocalDateTimeInterval, LocalDateTime> getEndF() {
        return new Function<LocalDateTimeInterval, LocalDateTime>() {
            public LocalDateTime apply(LocalDateTimeInterval i) {
                return i.getEnd();
            }
        };
    }

}
