package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.event.avail.AvailabilityOverlap;
import ru.yandex.calendar.logic.resource.ResourceRoutines;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.email.Email;

public abstract class ModifyEventResult {

    public static Modified modified(long showEventId, LocalDate showDate, int sequence, ListF<String> externalIds) {
        return new Modified(showEventId, showDate, sequence, externalIds);
    }

    public static ResourceBusyOverlap resourceBusyOverlap(Resource resource, AvailabilityOverlap overlap, DateTimeZone tz) {
        return new ResourceBusyOverlap(
                resource.getName().getOrElse(""), ResourceRoutines.getResourceEmail(resource),
                overlap.getInstanceInterval().getStart().toDateTime(tz).toLocalDateTime(),
                overlap.getStart().toDateTime(tz).toLocalDateTime());
    }

    public Modified asModified() {
        return (Modified) this;
    }

    public ResourceBusyOverlap asBusyOverlap() {
        return (ResourceBusyOverlap) this;
    }

    @Getter
    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class Modified extends ModifyEventResult {
        private final String status = "ok";
        private final int sequence;
        private final long showEventId;
        private final LocalDate showDate;
        private final LocalDateTime endTs; // temporary for compatibility
        private final ListF<String> externalIds;

        public Modified(long showEventId, LocalDate showDate, int sequence, ListF<String> externalIds) {
            this.sequence = sequence;
            this.showEventId = showEventId;
            this.showDate = showDate;
            this.endTs = showDate.toLocalDateTime(LocalTime.MIDNIGHT);
            this.externalIds = externalIds;
        }
    }

    @Getter
    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class ResourceBusyOverlap extends ModifyEventResult{
        private final String status = "busy-overlap";
        private final String resourceName;
        private final Email resourceEmail;

        private final LocalDateTime instanceStart;
        private final LocalDateTime overlapStart;

        public ResourceBusyOverlap(
                String resourceName, Email resourceEmail,
                LocalDateTime instanceStart, LocalDateTime overlapStart)
        {
            this.resourceName = resourceName;
            this.resourceEmail = resourceEmail;

            this.instanceStart = instanceStart;
            this.overlapStart = overlapStart;
        }
    }
}
