package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Getter
@BenderBindAllFields
public class NowTimeInfo {
    private final LocalDateTime now;
    private final String tz;
    private final Option<String> lastOfferedGeoTz;
    private final Option<String> currentOfficeTz;

    public NowTimeInfo(
            LocalDateTime now, String tz,
            Option<String> lastOfferedGeoTz, Option<String> currentOfficeTz)
    {
        this.now = now;
        this.tz = tz;
        this.lastOfferedGeoTz = lastOfferedGeoTz;
        this.currentOfficeTz = currentOfficeTz;
    }
}
