package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author gutman
 */
@Getter
@Bendable
public class OfficesInfo {

    @BenderPart(name = "office", wrapperName = "offices")
    private final ListF<OfficeInfo> offices;

    public OfficesInfo(ListF<OfficeInfo> offices) {
        this.offices = offices;
    }

    public Option<OfficeInfo> find(long id) {
        return offices.find(o -> o.id == id);
    }

    @Getter
    @Bendable
    public static class OfficeInfo {
        @BenderPart
        private final String name;
        @BenderPart
        private final long id;
        @BenderPart
        private final String cityName;
        @BenderPart
        private final int tzOffset;  // relative to user timezone

        public OfficeInfo(String name, long id, String cityName, int tzOffset) {
            this.name = name;
            this.id = id;
            this.cityName = cityName;
            this.tzOffset = tzOffset;
        }
    }

}
