package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@Getter
@Bendable
public class OfficesTzInfo {
    @BenderPart(name = "office", wrapperName = "offices")
    private final ListF<OfficeTzInfo> offices;

    public OfficesTzInfo(ListF<OfficeTzInfo> offices) {
        this.offices = offices;
    }

    public Option<Integer> findOffset(long officeId) {
        return offices.find(id -> id.id == officeId).map(OfficeTzInfo::getTzOffset);
    }

    @Getter
    @Bendable
    public static class OfficeTzInfo {
        @BenderPart
        private final long id;
        @BenderPart
        private final int tzOffset;

        public OfficeTzInfo(long id, int tzOffset) {
            this.id = id;
            this.tzOffset = tzOffset;
        }
    }
}
