package ru.yandex.calendar.frontend.webNew.dto.out;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class ReservationInfo {
    @BenderFlatten
    private final SubjectsAvailabilities availabilities;
    private final Option<NameI18n> readable;

    public ReservationInfo(SubjectsAvailabilities availabilities, Option<NameI18n> readable) {
        this.availabilities = availabilities;
        this.readable = readable;
    }

    public Option<SubjectAvailability> findAvailability(Email email) {
        return availabilities.findAvailability(email);
    }

    public Option<String> findAvailabilityValue(Email email) {
        return availabilities.findAvailabilityValue(email);
    }

    public Option<NameI18n> getReadable() {
        return readable;
    }
}
