package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.ResourceType;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.email.Email;

/**
 * @author gutman
 */
@Getter
@Bendable
public class ResourcesInfo {

    @BenderPart(name = "resource", wrapperName = "resources")
    private final ListF<ResourceInfo> resources;
    @BenderPart
    private final int foundTotal;

    public ResourcesInfo(ListF<ResourceInfo> resources, int foundTotal) {
        this.resources = resources;
        this.foundTotal = foundTotal;
    }

    public ListF<Email> getEmails() {
        return resources.map(ResourceInfo::getEmail);
    }

    public Option<ResourceInfo> find(Email email) {
        return resources.find(r -> r.getEmail().equalsIgnoreCase(email));
    }

    @Getter
    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class ResourceInfo {
        private final String name;
        private final Email email;
        private final ResourceType type;
        private final long officeId;
        private final Option<Long> officeStaffId;
        @BenderFlatten
        private final AvailabilityInfo availability;
        private final Option<Boolean> canAdmin;

        public ResourceInfo(
                String name, Email email, ResourceType type, long officeId, Option<Long> officeStaffId,
                Option<AvailabilityInfo> availability, Option<Boolean> canAdmin)
        {
            this.name = name;
            this.email = email;
            this.type = type;
            this.officeId = officeId;
            this.officeStaffId = officeStaffId;
            this.availability = availability.getOrElse(AvailabilityInfo::empty);
            this.canAdmin = canAdmin;
        }
    }
}
