package ru.yandex.calendar.frontend.webNew.dto.out;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.email.Email;

/**
* @author gutman
*/
@Bendable
public class SubjectsAvailabilities {

    @BenderPart(name = "subject-availability", wrapperName = "subject-availabilities")
    private final ListF<SubjectAvailability> subjectAvailabilities;

    public SubjectsAvailabilities(ListF<SubjectAvailability> subjectAvailabilities) {
        this.subjectAvailabilities = subjectAvailabilities;
    }

    public ListF<SubjectAvailability> getSubjectAvailabilities() {
        return subjectAvailabilities;
    }

    public Option<SubjectAvailability> findAvailability(Email email) {
        return subjectAvailabilities.find(a -> a.getEmail().equalsIgnoreCase(email));
    }

    public Option<String> findAvailabilityValue(Email email) {
        return findAvailability(email).map(SubjectAvailability::getAvailability);
    }
}
