package ru.yandex.calendar.frontend.webNew.dto.out;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.email.Email;

/**
* @author gutman
*/
@Bendable
public class SubjectsAvailabilityIntervals {

    @BenderPart(name = "subject-availability", wrapperName = "subject-availabilities")
    private final ListF<SubjectAvailabilityIntervals> subjectAvailabilities;

    public SubjectsAvailabilityIntervals(ListF<SubjectAvailabilityIntervals> subjectAvailabilities) {
        this.subjectAvailabilities = subjectAvailabilities;
    }

    public Option<SubjectAvailabilityIntervals> findIntervals(Email email) {
        return subjectAvailabilities.find(a -> a.getEmail().equalsIgnoreCase(email));
    }
}
