package ru.yandex.calendar.frontend.webNew.dto.out;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author Ivan Nikolaev <ivannik@yandex-team.ru>
 */

@BenderBindAllFields
public class SubscribeMobileInput {
    private final String oauthToken;
    private final String pushToken;
    private final String appName;
    private final String platform;
    private final String uuid;
    private final Option<String> filter;
    private final Option<String> extra;

    public SubscribeMobileInput(
            String oauthToken,
            String pushToken,
            String appName,
            String platform,
            String uuid,
            Option<String> filter,
            Option<String> extra) {
        this.oauthToken = oauthToken;
        this.appName = appName;
        this.platform = platform;
        this.uuid = uuid;
        this.pushToken = pushToken;
        this.filter = filter;
        this.extra = extra;
    }

    public String getOauthToken() {
        return oauthToken;
    }

    public String getPushToken() {
        return pushToken;
    }

    public String getAppName() {
        return appName;
    }

    public String getPlatform() {
        return platform;
    }

    public String getUuid() {
        return uuid;
    }

    public Option<String> getFilter() {
        return filter;
    }

    public Option<String> getExtra() {
        return extra;
    }
}
