package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.suggest.SuggestedDates;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Getter
@BenderBindAllFields
public class SuggestDatesInfo {

    private final ListF<Date> dates;
    private final Option<LocalDate> backwardDate;
    private final Option<LocalDate> forwardDate;

    public SuggestDatesInfo(
            ListF<Date> dates,
            Option<LocalDate> backwardDate,
            Option<LocalDate> forwardDate)
    {
        this.dates = dates;
        this.backwardDate = backwardDate;
        this.forwardDate = forwardDate;
    }

    public static SuggestDatesInfo of(SuggestedDates suggest) {
        return new SuggestDatesInfo(
                suggest.getDates().map(Date::new),
                suggest.getBackwardDate(),
                suggest.getForwardDate());
    }

    public ListF<LocalDate> getLocalDates() {
        return dates.map(Date::getDate);
    }

    @Getter
    @BenderBindAllFields
    public static class Date {
        private final LocalDate date;

        public Date(LocalDate date) {
            this.date = date;
        }
    }
}
