package ru.yandex.calendar.frontend.webNew.dto.out;

import org.joda.time.DateTimeConstants;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class TimezonesInfo {

    private final ListF<TimezoneInfo> timezones;

    public TimezonesInfo(ListF<TimezoneInfo> timezones) {
        this.timezones = timezones;
    }

    @BenderBindAllFields
    public static class TimezoneInfo {
        public final String id;
        public final int offset;

        public TimezoneInfo(String id, int offset) {
            this.id = id;
            this.offset = offset;
        }

        public static TimezoneInfo forID(String id) {
            return new TimezoneInfo(id, -DateTimeZone.forID(id).getOffset(null) / DateTimeConstants.MILLIS_PER_MINUTE);
        }
    }
}
