package ru.yandex.calendar.frontend.webNew.dto.out;

import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
public abstract class UserOrResourceInfo {

    public static User user(WebUserInfo user) {
        return new User(user);
    }

    public static Resource resource(WebResourceInfo resource) {
        return new Resource(resource);
    }

    @Bendable
    public static class User extends UserOrResourceInfo {
        @BenderFlatten
        private final WebUserInfo info;
        @BenderPart
        private final String type = "user";

        private User(WebUserInfo info) {
            this.info = info;
        }
    }

    @Bendable
    public static class Resource extends UserOrResourceInfo {
        @BenderFlatten
        private final WebResourceInfo info;
        @BenderPart
        private final String type = "resource";

        private Resource(WebResourceInfo info) {
            this.info = info;
        }
    }
}
