package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.email.Email;

/**
 * @author Daniel Brylev
 */
@Getter
@Bendable
public class UsersAndResourcesInfo {
    @BenderPart
    private ListF<WebUserInfo> users;
    @BenderPart
    private ListF<WebResourceInfo> resources;
    @BenderPart
    private ListF<String> notFound;

    public UsersAndResourcesInfo(ListF<WebUserInfo> users, ListF<WebResourceInfo> resources, ListF<String> notFound) {
        this.users = users;
        this.resources = resources;
        this.notFound = notFound;
    }

    public ListF<Email> getEmails() {
        return users.map(WebUserInfo::getEmail).plus(resources.map(WebResourceInfo::getEmail));
    }
}
