package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.ResourceType;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.email.Email;

/**
 * @author Sergey Shinderuk
 */
@Getter
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class WebResourceInfo {

    public final long officeId;
    public final String name;
    public final String alterName;
    public final Email email;
    public final String phone;
    public final String video;
    public final String description;
    public final int seats;
    public final int capacity;
    public final boolean voiceConferencing;
    public final int projector;
    public final int lcdPanel;
    public final boolean markerBoard;
    public final boolean desk;
    public final boolean guestWifi;
    public final Option<Integer> floor;
    public final Option<String> mapUrl;
    public final boolean active;
    public final ResourceType resourceType;
    public final Option<Boolean> repetitionUnacceptable;
    public final Option<Boolean> canAdmin;
    public final Option<String> cityName;
    public final Option<String> officeName;
    public final Option<String> groupName;
    public final Option<Integer> tzOffset;

    public WebResourceInfo(long officeId, String name, String alterName, Email email, String phone,
            String video, String description, int seats, int capacity, boolean voiceConferencing,
            int projector, int lcdPanel, boolean markerBoard, boolean desk, boolean guestWifi,
            Option<Integer> floor, Option<String> mapUrl,
            boolean active, ResourceType resourceType, Option<Boolean> repetitionUnacceptable, Option<Boolean> canAdmin,
            Option<String> cityName, Option<String> officeName, Option<String> groupName, Option<Integer> tzOffset)
    {
        this.officeId = officeId;
        this.name = name;
        this.alterName = alterName;
        this.email = email;
        this.phone = phone;
        this.video = video;
        this.description = description;
        this.seats = seats;
        this.capacity = capacity;
        this.voiceConferencing = voiceConferencing;
        this.projector = projector;
        this.lcdPanel = lcdPanel;
        this.markerBoard = markerBoard;
        this.desk = desk;
        this.guestWifi = guestWifi;
        this.floor = floor;
        this.mapUrl = mapUrl;
        this.active = active;
        this.resourceType = resourceType;
        this.repetitionUnacceptable = repetitionUnacceptable;
        this.canAdmin = canAdmin;
        this.cityName = cityName;
        this.officeName = officeName;
        this.groupName = groupName;
        this.tzOffset = tzOffset;
    }
}
