package ru.yandex.calendar.frontend.webNew.dto.out;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.YandexUserParticipantInfo;
import ru.yandex.inside.passport.AbstractPassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;

@Value
@BenderBindAllFields
public class WebUserInfo {
    Option<Long> uid;
    String name;
    Email email;
    Option<String> login;
    Option<Long> officeId;

    public static WebUserInfo fromUserParticipantInfo(UserParticipantInfo info) {
        if (info instanceof YandexUserParticipantInfo) {
            YandexUserParticipantInfo p = (YandexUserParticipantInfo) info;
            return new WebUserInfo(
                    p.getUid().map(AbstractPassportUid::getUid),
                    p.getName(), p.getEmail(), p.getLogin(),
                    p.getSettingsYt().filterMap(SettingsYt.getActiveOfficeIdF()));
        } else {
            Option<Long> uid = info.getUid().map(AbstractPassportUid::getUid);
            return new WebUserInfo(uid, info.getName(), info.getEmail(), Option.empty(), Option.empty());
        }
    }
}
