package ru.yandex.calendar.frontend.webNew.suggest;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class OfficeUsers {
    private final long officeId;
    private final ListF<User> users;

    public OfficeUsers(long officeId, ListF<User> users) {
        this.officeId = officeId;
        this.users = users;
    }

    public OfficeFloor findMostUsersFloor(PassportUid clientUid) {
        ListF<Integer> floorNums = users.filterMap(User.getFloorNumF());

        if (floorNums.isEmpty()) return new OfficeFloor(officeId, Option.<Integer>empty());

        Tuple2List<Integer, Integer> floorCounts = floorNums
                .groupBy(Function.<Integer>identityF()).entries().map2(Cf.List.sizeF());

        ListF<Integer> mostUsersFloors = floorCounts.filterBy2(Cf.Integer.equalsF(floorCounts.get2().max())).get1();
        Option<Integer> userFloor = users.find(User.getUidF().andThenEquals(clientUid)).filterMap(User.getFloorNumF());

        int closestToUserMostUsersFloor = mostUsersFloors
                .reduceLeft(distanceF().bind1(userFloor.getOrElse(0)).andThenNaturalComparator().minF());

        return new OfficeFloor(officeId, Option.of(closestToUserMostUsersFloor));
    }

    private static Function2<Integer, Integer, Integer> distanceF() {
        return new Function2<Integer, Integer, Integer>() {
            public Integer apply(Integer i1, Integer i2) {
                return Math.abs(i1 - i2);
            }
        };
    }

    public int getUsersCount() {
        return users.size();
    }

    public static Function<OfficeUsers, Long> getOfficeIdF() {
        return new Function<OfficeUsers, Long>() {
            public Long apply(OfficeUsers o) {
                return o.officeId;
            }
        };
    }

    public static Function2<Long, ListF<User>, OfficeUsers> consF() {
        return new Function2<Long, ListF<User>, OfficeUsers>() {
            public OfficeUsers apply(Long i, ListF<User> users) {
                return new OfficeUsers(i, users);
            }
        };
    }

    public static class User {
        private final PassportUid uid;
        private final Option<Integer> floorNum;

        public User(PassportUid uid, Option<Integer> floorNum) {
            this.uid = uid;
            this.floorNum = floorNum;
        }

        public static Function<User, Option<Integer>> getFloorNumF() {
            return new Function<User, Option<Integer>>() {
                public Option<Integer> apply(User u) {
                    return u.floorNum;
                }
            };
        }

        public static Function<User, PassportUid> getUidF() {
            return new Function<User, PassportUid>() {
                public PassportUid apply(User u) {
                    return u.uid;
                }
            };
        }
    }
}
