package ru.yandex.calendar.frontend.worker;

import lombok.val;
import org.joda.time.Duration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.impl.SingletonMap;
import ru.yandex.commune.alive2.AliveAppsContextConfiguration;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.commune.bazinga.context.BazingaControllerContextConfiguration;
import ru.yandex.commune.bazinga.impl.controller.BazingaControllerConfiguration;
import ru.yandex.commune.bazinga.impl.controller.ControllerTaskOptions;
import ru.yandex.scheduler.QuorumWorkerChooser;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        BazingaControllerContextConfiguration.class,
        AliveAppsContextConfiguration.class
})
public class CalendarBazingaControllerContextConfiguration {
    private static final String QUORUM_KEY = "QUORUM";
    private static final Duration POLL_DELAY = Duration.standardSeconds(20);
    private static final Duration GC_DELAY = Duration.standardMinutes(10);

    @Bean
    public BazingaControllerConfiguration bazingaControllerConfiguration(AliveAppsHolder holder) {
        val chooser = new QuorumWorkerChooser(holder);
        val map = new SingletonMap(QUORUM_KEY, chooser) {
            @Override
            public Option getO(Object key) {
                return Option.of(chooser);
            }
        };
        return new BazingaControllerConfiguration(POLL_DELAY, GC_DELAY, map);
    }

    @Bean
    public ControllerTaskOptions controllerTaskOptions() {
        return new ControllerTaskOptions(false, false);
    }
}
