package ru.yandex.calendar.frontend.worker;

import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

public abstract class CalendarCronTask extends CronTask {

    protected abstract void doExecute(ExecutionContext executionContext) throws Exception;

    @Override
    public final void execute(ExecutionContext executionContext) throws Exception {
        CalendarTaskUtils.executeWithCalendarRequest(
                executionContext, ActionSource.WORKER, () -> doExecute(executionContext));
    }
}
