package ru.yandex.calendar.frontend.worker;

import org.joda.time.Duration;
import org.springframework.context.annotation.Bean;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.commune.monica.MonicaMasterSnapshotSupplier;
import ru.yandex.commune.monica.pusher.MonicaFieldValuesExtractorRegistry;
import ru.yandex.commune.monica.pusher.graphite.GraphitePusherConfiguration;
import ru.yandex.commune.monica.pusher.graphite.MonicaGraphitePusher;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.monica.core.name.MetricNamespaceProjection;
import ru.yandex.misc.monica.core.name.NameDimension;

/**
 * @author dbrylev
 */
public class CalendarMonicaGraphitePusherContextConfiguration {

    @Bean
    public GraphiteClient graphiteClient(EnvironmentType environmentType) {
        if (environmentType == EnvironmentType.PRODUCTION) {
            return new GraphiteClient();
        } else {
            return null;
        }
    }

    @Bean
    public MonicaGraphitePusher monicaGraphitePusher(
            MonicaMasterSnapshotSupplier monicaLocalSnapshotSupplier,
            GraphiteClient graphiteClient)
    {
        if (graphiteClient == null) return null;

        GraphitePusherConfiguration configuration = new GraphitePusherConfiguration(
                Duration.standardMinutes(1),
                "mail.calendar.monica",
                Cf.list(new MetricNamespaceProjection(NameDimension.GROUP_NAME)),
                MonicaFieldValuesExtractorRegistry.defaultRegistry());

        MonicaGraphitePusher pusher = new MonicaGraphitePusher(configuration, graphiteClient);

        monicaLocalSnapshotSupplier.registerConsumer(pusher);

        return pusher;
    }
}
