package ru.yandex.calendar.frontend.worker;

import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;

public abstract class CalendarOnetimeTask<T> extends OnetimeTaskSupport<T> {

    public CalendarOnetimeTask(T parameters) {
        super(parameters);
    }

    public CalendarOnetimeTask(Class<T> parametersClass) {
        super(parametersClass);
    }

    protected abstract void doExecute(T parameters, ExecutionContext context) throws Exception;

    protected ActionSource getActionSource() {
        return ActionSource.WORKER;
    }

    @Override
    protected final void execute(T parameters, ExecutionContext context) throws Exception {
        CalendarTaskUtils.executeWithCalendarRequest(context, getActionSource(), () -> doExecute(parameters, context));
    }
}
